#include <iostream>
#include <vector>
#include <set>

using namespace std;

#define ubrzaj ios_base::sync_with_stdio(false); cin.tie(NULL); cout.tie(NULL);
typedef long long ll;

struct TopKSum
{
    int k;
    ll current_sum = 0;
    multiset<ll> smallest, rest;

    TopKSum(int _k) : k(_k) {}

    void add(ll val) {
        smallest.insert(val);
        current_sum += val;
        if (smallest.size() > k) {
            auto it = prev(smallest.end());
            current_sum -= *it;
            rest.insert(*it);
            smallest.erase(it);
        }
    }

    void remove(ll val) {
        if (smallest.find(val) != smallest.end()) {
            current_sum -= val;
            smallest.erase(smallest.find(val));
            if (!rest.empty()) {
                auto it = rest.begin();
                current_sum += *it;
                smallest.insert(*it);
                rest.erase(it);
            }
        } else {
            rest.erase(rest.find(val));
        }
    }
};

int main() {
    ubrzaj;
    int n, m, k_val;
    cin >> n >> m >> k_val;

    vector<ll> a(n + 1);
    vector<ll> pref(n + 1, 0);
    vector<TopKSum> tk;
    for (int i = 1; i <= n; i++) {
        cin >> a[i];
        pref[i] = pref[i - 1] + a[i];
    }

    for (int i = 0; i < m; i++) {
        tk.add(pref[i]);
    }

    for (int i = 1; i <= n - m + 1; i++) {
        int tail = i - 1;
        int head = i + m - 1;

        ll window_sum = pref[head] - pref[tail];

        ll max_aura = window_sum + (ll)(k_val - 1) * pref[head] - tk.current_sum;

        cout << max_aura << (i == n - m + 1 ? "" : " ");

        if (i <= n - m) {
            tk.remove(pref[tail]);
            tk.add(pref[head]);
        }
    }
    cout << endl;

    return 0;
}